﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:param name="helpType">b</xsl:param>
<xsl:param name="helpTarget">c</xsl:param>
<xsl:param name="helpSubTarget">d</xsl:param>
<xsl:param name="helpPath">c:\</xsl:param>

<xsl:template match="/">

	<xsl:variable name="f1">
		<xsl:value-of select="count(//help/dynamicHelp)"/>
	</xsl:variable>
	
	<xsl:variable name="f2">
		<xsl:value-of select="count(//help/helpType[@value=$helpType]/dynamicHelp)"/>
	</xsl:variable>
	
	<xsl:variable name="f3">
		<xsl:value-of select="count(//help/helpType[@value=$helpType]/helpTarget[@value=$helpTarget]/dynamicHelp)"/>
	</xsl:variable>
	
	<xsl:variable name="f4">
		<xsl:value-of select="count(//help/helpType[@value=$helpType]/helpTarget[@value=$helpTarget]/helpSubTarget[@value=$helpSubTarget]/dynamicHelp)"/>
	</xsl:variable>
	
  <html>
	<head>
		<title>Online help</title>
		<meta http-equiv="content-type" content="text/html;charset=utf-8"/>
		<link rel="stylesheet" type="text/css" href="DynamicHelp.css"/>
	</head>
	
	<body style="overflow-y:auto;overflow-x:hidden">
	
		<table CLASS="deepsea">
			<tr>
			<td align="top" width="82">
          <p id="TopNavigation"><a>
			<xsl:attribute name="href">its:<xsl:value-of select="$helpPath"/><xsl:value-of select="//help/url"/></xsl:attribute>
            <xsl:attribute name="class">TopNavigation_Contents</xsl:attribute>            
			<xsl:attribute name="onclick">return false</xsl:attribute>
            <xsl:text>&#160;</xsl:text>
          </a></p>
        </td>
        <td align="top" width="56">
          <p id="TopNavigation"><a>
			<xsl:attribute name="href">its:<xsl:value-of select="$helpPath"/><xsl:value-of select="//help/url"/></xsl:attribute>
            <xsl:attribute name="class">TopNavigation_Index</xsl:attribute>            
			<xsl:attribute name="onclick">return false</xsl:attribute>
            <xsl:text>&#160;</xsl:text>
          </a></p>
        </td>
        <td align="top" width="61">
          <p id="TopNavigation"><a>
			<xsl:attribute name="href">its:<xsl:value-of select="$helpPath"/><xsl:value-of select="//help/url"/></xsl:attribute>
            <xsl:attribute name="class">TopNavigation_Search</xsl:attribute>            
			<xsl:attribute name="onclick">return false</xsl:attribute>
            <xsl:text>&#160;</xsl:text>
          </a></p>
        </td>        
		<td align="top" width="100%">
          <a>
            <xsl:attribute name="class">TopNavigation_empty</xsl:attribute>            
            <xsl:text>&#160;</xsl:text>
          </a>
        </td>        		
			</tr>
		</table>

		<xsl:choose>
			<xsl:when test="$f4>0"><xsl:call-template name="dh_level_subtarget"/></xsl:when>
			<xsl:when test="$f3>0"><xsl:call-template name="dh_level_target"/></xsl:when>
			<xsl:when test="$f2>0"><xsl:call-template name="dh_level_type"/></xsl:when>
			<xsl:when test="$f1>0"><xsl:call-template name="dh_level_root"/></xsl:when>
			<xsl:otherwise><xsl:call-template name="dh_level_unknown"/></xsl:otherwise>		
		</xsl:choose>
	
	</body>
	</html>
  </xsl:template>
  
  <xsl:template name="dh_level_subtarget">
	<xsl:call-template name="dh_display_tree">
		<xsl:with-param name="node" select="//help/helpType[@value=$helpType]/helpTarget[@value=$helpTarget]/helpSubTarget[@value=$helpSubTarget]/dynamicHelp"/>
	</xsl:call-template>
  </xsl:template>
  
  <xsl:template name="dh_level_target">
	<xsl:call-template name="dh_display_tree">
		<xsl:with-param name="node" select="//help/helpType[@value=$helpType]/helpTarget[@value=$helpTarget]/dynamicHelp"/>
	</xsl:call-template>
  </xsl:template>
  
  <xsl:template name="dh_display_tree">
	<xsl:param name="node" select="/*"/>
	
	<table cellspacing="0" cellpadding="0" border="0">
		<xsl:for-each select="$node/group">
		<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td>
						<p>
							<xsl:attribute name="class">l2navigation</xsl:attribute>

              <xsl:variable name="countOfItems">
                <xsl:value-of select="count(item)"/>
              </xsl:variable>

              <xsl:choose>
                <xsl:when test="$countOfItems > 0">
                  <img border="0">
                    <xsl:attribute name="src">book_open.jpg</xsl:attribute>
                  </img>
                </xsl:when>
                <xsl:otherwise>
                  <img border="0">
                    <xsl:attribute name="src">book.jpg</xsl:attribute>
                  </img>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:text>&#09;</xsl:text><b><xsl:value-of select="@displayName"/></b>
						</p>
					</td>					
				</tr>
				<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<xsl:for-each select="item">	
					<tr>
						<td width="8"></td>
						<td width="100%">
							<p id="StdNavigation">
								<a>
									<xsl:attribute name="class">l1navigation</xsl:attribute>								
									<xsl:attribute name="onclick">return false</xsl:attribute>
									<xsl:attribute name="href">its:<xsl:value-of select="$helpPath"/><xsl:value-of select="url"/></xsl:attribute>
									<xsl:value-of select="@displayName"/>
								</a>
							</p>			
						</td>
					</tr>
					</xsl:for-each>
				</table>
				</table>
		</td>
		</tr>
		<tr><td></td></tr>
		</xsl:for-each>
	</table>
	
	<xsl:for-each select="$node/item">
		<p id="StdNavigation">			
			<a href="">
				<xsl:attribute name="class">l1navigation</xsl:attribute>						
				<xsl:attribute name="onclick">return false</xsl:attribute>			
				<xsl:attribute name="href">its:<xsl:value-of select="$helpPath"/><xsl:value-of select="url"/></xsl:attribute>
				<xsl:value-of select="@displayName"/>
			</a>
		</p>
		<br></br>					
	</xsl:for-each>
	
  </xsl:template>
  
  <xsl:template name="dh_level_type">
		<xsl:call-template name="dh_display_tree">
			<xsl:with-param name="node" select="//help/helpType[@value=$helpType]/dynamicHelp"/>
		</xsl:call-template>
  </xsl:template>
  
  <xsl:template name="dh_level_root">
	<xsl:call-template name="dh_display_tree">
			<xsl:with-param name="node" select="//help/dynamicHelp"/>
	</xsl:call-template>
  </xsl:template>
  
  <xsl:template name="dh_level_unknown">
	<p></p>
  </xsl:template>

</xsl:stylesheet>